﻿namespace FAQ.Entities.fixtures
{

    public class FactoryVersion
    {
        /// <summary>
        /// Retourne la liste des entités.
        /// </summary>
        /// <returns>Liste de Questions</returns>
        public static List<Question> GetQuestions()
        {

            string filePath = "..\\FAQ.Entities\\fixtures\\Questions.txt";
            var lines = File.ReadAllLines(filePath);
            return lines
                .Select(line => line.Split(';'))
                .Where(parts => parts.Length == 6)
                .Select(parts => new Question(int.Parse(parts[0]), parts[1], parts[2], parts[3], parts[4], parts[5]))
                .ToList();
        }
    }
}
